const pino = require('pino');

function createLogger(level = 'info') {
  return pino({
    level,
    transport:
      process.env.NODE_ENV === 'production'
        ? undefined
        : {
            target: 'pino-pretty',
            options: { colorize: true, translateTime: 'SYS:standard' }
          }
  });
}

module.exports = { createLogger };

