const wildberries = require('./wildberries');
const lamoda = require('./lamoda');

const MARKETPLACES = [wildberries, lamoda];

function detectMarketplace(url) {
  const u = String(url || '');
  for (const mp of MARKETPLACES) {
    try {
      if (mp.match(u)) return mp.id;
    } catch (_) {
      // ignore
    }
  }
  return 'unknown';
}

function getMarketplace(id) {
  return MARKETPLACES.find((m) => m.id === id);
}

module.exports = {
  detectMarketplace,
  getMarketplace,
  MARKETPLACES
};

