const { firstVisibleTextFromLocators } = require('./_helpers');

module.exports = {
  id: 'lamoda',
  match: (url) => /(^|\/\/)(www\.)?lamoda\.(ru|kz|by)\//i.test(url),

  // TODO: replace/extend with the exact locators you will provide.
  priceLocators: [
    '[data-testid="product-price"]',
    '[data-testid="price"]',
    // common class-based fallbacks (may change)
    '.product-price__current',
    '.x-product-price__current',
    // weak fallback
    ':has-text("₽")'
  ],

  async getRawPriceText({ page, timeoutMs }) {
    return firstVisibleTextFromLocators(page, this.priceLocators, timeoutMs);
  }
};

